jQuery(window).on("load", function () {

    let el_select_gateways = jQuery('#digit_tapp');
    let el_textarea_pattern = jQuery('textarea[name="dig_messagetemplate"]');
    
    if (1000 == el_select_gateways.find(':selected').val()) {
        el_textarea_pattern.prop('readonly', true);
        el_textarea_pattern.css({
            "backgroundColor": "whitesmoke"
        });

        el_textarea_pattern.before(`
            <p style="color: orange;">
            این مورد را در بخش مرتبط به تنظیمات افزونه دیجیتس پلاگین وب وان تنظیم کنید.
            </p>
        `);
    }
    
    el_select_gateways.on('change', function(e) {
        let selected_gateway = el_select_gateways.find(':selected').val();
    
        if (1000 == selected_gateway) {
            el_textarea_pattern.prop('readonly', true);
            el_textarea_pattern.css({
                "backgroundColor": "whitesmoke"
            });
            el_textarea_pattern.before(`
                <p style="color: orange;">
                    نمونه متن را در بخش
                    <strong>تنظیمات افزونه دیجیتس</strong>
                    موجود در
                    <strong>افزونه پیامک وب‌وان</strong>
                    تنظیم کنید.
                </p>
            `);
        } else {
            el_textarea_pattern.prop('readonly', false);
            el_textarea_pattern.css({
                "backgroundColor": "unset"
            });
            el_textarea_pattern.prev('p').remove();
        }
    });
});


jQuery(document).ready(function($) {
    if ($('#form-digits-settings').length || $('#form-gravityforms-template-otp').length) {
        function variables_and_values_validation()
        {
            $('.select-variable-value').on('change', function(e) {
                let index = $(this).attr('data-index');
                let selected_option = $(this).find(':selected');

                let el_related_input_variable_default = $(`.input-variable-default[data-index=${index}]`);

                if (selected_option.val()) {
                    el_related_input_variable_default.prop('required', false);
                } else {
                    el_related_input_variable_default.prop('required', true);
                }
            });
        }


        let el_select_send_method = $('#select-send-method');
        let el_select_sender_number = $('#select-sender-number');
        let el_select_pattern = $('#select-pattern');
        let el_p_show_pattern = $('#p-show-pattern');
        let el_tbody_variables_and_values = $('#tbody-variables-and-values');

        el_select_send_method.on('change', function(e) {
            let selected_option = $(this).find(':selected');

            let send_method = selected_option.val();
            if ('smart_otp' === send_method) {
                el_select_sender_number.val('');
                el_select_sender_number.prop('required', false);
                el_select_sender_number.prop('disabled', true);
            } else {
                el_select_sender_number.prop('required', true);
                el_select_sender_number.prop('disabled', false);
            }
        });
        
        el_select_pattern.on('change', function(e) {
            el_p_show_pattern.text('');
            el_tbody_variables_and_values.html('');

            let selected_option = $(this).find(':selected');

            if (!selected_option) {
                return;
            }

            pattern_text = selected_option.attr('data-pattern_text');
            el_p_show_pattern.text(pattern_text);
            
            let pattern_variables = selected_option.attr('data-pattern_variables');
            if (!pattern_variables) {
                return;
            }
            pattern_variables = JSON.parse(pattern_variables);

            pattern_variables.forEach(function(item, index) {
                el_tbody_variables_and_values.append(`
                    <tr>
                        <td>
                            ${item.index} - ${item.variable}
                            <input type="hidden" name="variables_and_values[${index}][index]" value="${item.index}" />
                            <input type="hidden" name="variables_and_values[${index}][variable]" value="${item.variable}" />
                        </td>
                        <td>
                            <select name="variables_and_values[${index}][value]" class="select-variable-value" data-index="${item.index}">
                                <option value="">انتخاب</option>
                                <option value="{NAME}">NAME</option>
                                <option value="{DOMAIN}">DOMAIN</option>
                                <option value="{OTP}">OTP</option>
                            </select>
                        </td>
                        <td>
                            <input type="text" name="variables_and_values[${index}][default]" class="input-variable-default" data-index="${item.index}" required />
                        </td>
                    </tr>
                `);
            });

            variables_and_values_validation();
        });

        variables_and_values_validation();
    }


});