jQuery(document).ready(function() {

    let el_select_form = jQuery('#select_form');
    let el_select_pattern = jQuery('#select_pattern');
    let el_select_variables = jQuery('#select_pattern');
    let el_table = jQuery('#table_pattern_variables_and_form_fields > tbody');
    let el_select_to_number = jQuery('#select_to_number');
    let el_span_pattern = jQuery('#span_pattern');

    let field_options = '';
    el_select_form.on('change', function() {
        el_select_to_number.val('').change();
        el_select_to_number.html('');
        let field_options_to = '<option value="">انتخاب</option>';
        el_select_to_number.html(field_options_to);


        field_options = '';

        if (!el_select_form.find(':selected').val()) {
            return;
        }

        el_select_pattern.val('').change();

        let form_fields = JSON.parse(
            el_select_form.find(':selected').attr('data-form_fields')
        );

        field_options = '';
        form_fields.forEach(function(item) {
            field_options += `<option value="${item.inputs}">${item.id} - ${item.label}</option>`;
        });

        el_table.html('');

        form_fields.forEach(function(item) {
            if ('phone' == item.type) {
                field_options_to += `<option value="${item.id}">${item.id} - ${item.label}</option>`;
            }
        });
        el_select_to_number.html(field_options_to);
    });


    el_select_pattern.on('change', function() {
        el_table.html('');
        el_span_pattern.html('');

        let selected_pattern = el_select_pattern.find(':selected');
        if (!selected_pattern.val() || '' == field_options) {
            return;
        }

        el_span_pattern.html(
            selected_pattern.attr('data-pattern_text')
        );

        let pattern_variables = JSON.parse(
            el_select_variables.find(':selected').attr('data-pattern_variables')
        );

        let rows = '';
        pattern_variables.forEach(function(item, index) {
            let select = `
                <select name="variables_and_values[${index}][value]">
                    <option value="">انتخاب</value>
                    {options}
                    <optgroup label="پیش فرض">
                        <option value="DATE">تاریخ</option>
                        <option value="TIME">زمان</option>
                        <option value="DOMAIN">دامنه</option>
                    </optgroup>
                </select>
            `;
            select = select.replace('{options}', field_options);
            
            rows += `
                <tr>
                    <td>
                        ${item.index}
                        -
                        ${item.variable}
                        <input type="hidden" name="variables_and_values[${index}][index]" value="${item.index}" />
                        <input type="hidden" name="variables_and_values[${index}][variable]" value="${item.variable}" />
                    </td>
                    <td>
                        ${select}
                    </td>
                    <td>
                        <input type="text" name="variables_and_values[${index}][default]" />
                    </td>
                </tr>
            `;
        });
        el_table.html(rows);
    });

});