jQuery(document).ready(function($) {


    if ($('#form-woocommerce-template').length) {

        function variables_and_values_validation()
        {
            $('.select-variable-value').on('change', function(e) {
                let index = $(this).attr('data-index');
                let selected_option = $(this).find(':selected');

                let el_related_input_variable_default = $(`.input-variable-default[data-index=${index}]`);

                if (selected_option.val()) {
                    el_related_input_variable_default.prop('required', false);
                } else {
                    el_related_input_variable_default.prop('required', true);
                }
            });
        }


        let el_select_form = $('#select-form');
        let el_select_field = $('#select-field');
        let el_select_pattern = $('#select-pattern');
        let el_p_show_pattern = $('#p-show-pattern');
        let el_tbody_variables_and_values = $('#tbody-variables-and-values');

        let order_variables = JSON.parse($('#input-order-variables').val());
        let field_options = '';
        for(let key in order_variables) {
            field_options += `<option value="${key}">${order_variables[key]}</option>`;
        }

        el_select_pattern.on('change', function(e) {
            el_p_show_pattern.text('');
            el_tbody_variables_and_values.html('');

            let selected_option = $(this).find(':selected');

            pattern_text = selected_option.attr('data-pattern_text');
            el_p_show_pattern.text(pattern_text);
            
            let pattern_variables = selected_option.attr('data-pattern_variables');
            if (!pattern_variables) {
                return;
            }
            pattern_variables = JSON.parse(pattern_variables);

            pattern_variables.forEach(function(item, index) {
                el_tbody_variables_and_values.append(`
                    <tr>
                        <td>
                            ${item.index} - ${item.variable}
                            <input type="hidden" name="variables_and_values[${index}][index]" value="${item.index}" />
                            <input type="hidden" name="variables_and_values[${index}][variable]" value="${item.variable}" />
                        </td>
                        <td>
                            <select name="variables_and_values[${index}][value]" class="select-variable-value" data-index="${item.index}">
                                <option value="">انتخاب</option>
                                ${field_options}
                            </select>
                        </td>
                        <td>
                            <input type="text" name="variables_and_values[${index}][default]" class="input-variable-default" data-index="${item.index}" required />
                        </td>
                    </tr>
                `);
            });

            variables_and_values_validation();
        });



        variables_and_values_validation();
    }




    return;



    let el_select_form = jQuery('#select_form');
    let el_select_pattern = jQuery('#select_pattern');
    let el_select_variables = jQuery('#select_pattern');
    let el_table = jQuery('#table_pattern_variables_and_form_fields > tbody');
    let el_select_to_number = jQuery('#select_to_number');
    let el_span_pattern = jQuery('#span_pattern');

    let field_options = '';
    el_select_form.on('change', function() {
        el_select_to_number.val('').change();
        el_select_to_number.html('');
        let field_options_to = '<option value="">انتخاب</option>';
        el_select_to_number.html(field_options_to);


        field_options = '';

        if (!el_select_form.find(':selected').val()) {
            return;
        }

        el_select_pattern.val('').change();

        let form_fields = JSON.parse(
            el_select_form.find(':selected').attr('data-form_fields')
        );

        field_options = '';
        form_fields.forEach(function(item) {
            field_options += `<option value="${item.inputs}">${item.id} - ${item.label}</option>`;
        });

        el_table.html('');

        form_fields.forEach(function(item) {
            if ('phone' == item.type) {
                field_options_to += `<option value="${item.id}">${item.id} - ${item.label}</option>`;
            }
        });
        el_select_to_number.html(field_options_to);
    });


    el_select_pattern.on('change', function() {
        el_table.html('');
        el_span_pattern.html('');

        let selected_pattern = el_select_pattern.find(':selected');
        if (!selected_pattern.val() || '' == field_options) {
            return;
        }

        el_span_pattern.html(
            selected_pattern.attr('data-pattern_text')
        );

        let pattern_variables = JSON.parse(
            el_select_variables.find(':selected').attr('data-pattern_variables')
        );

        let rows = '';
        pattern_variables.forEach(function(item, index) {
            let select = `
                <select name="variables_and_values[${index}][value]">
                    <option value="">انتخاب</value>
                    {options}
                    <optgroup label="پیش فرض">
                        <option value="DATE">تاریخ</option>
                        <option value="TIME">زمان</option>
                        <option value="DOMAIN">دامنه</option>
                    </optgroup>
                </select>
            `;
            select = select.replace('{options}', field_options);
            
            rows += `
                <tr>
                    <td>
                        ${item.index}
                        -
                        ${item.variable}
                        <input type="hidden" name="variables_and_values[${index}][index]" value="${item.index}" />
                        <input type="hidden" name="variables_and_values[${index}][variable]" value="${item.variable}" />
                    </td>
                    <td>
                        ${select}
                    </td>
                    <td>
                        <input type="text" name="variables_and_values[${index}][default]" />
                    </td>
                </tr>
            `;
        });
        el_table.html(rows);
    });

});