jQuery(document).ready(function ($) {

    let data = JSON.parse('obj_placeholder');
    console.log(data);

    function show_timer(el, seconds)
    {
        el.prop('disabled', true);

        let countDownTime = seconds;
        const interval = setInterval(function() {
            countDownTime--;
            el.text(countDownTime);
            if (countDownTime <= 0) {
                clearInterval(interval);
                el.prop('disabled', false);
                el.text('ارسال مجدد');
            }
        }, 1000);
    }

    $('.webone-sms-gravity-send-otp').on('click', function (e) {
        e.preventDefault();
        let el = $(this);

        let form_id         = el.attr('data-form-id');
        let mobile_field_id = el.attr('data-mobile-field-id');
        let mobile = $("#" + data.mobile_field_id).val();

        if (!mobile) {
            alert('لطفا موبایل را وارد کنید');
            return;
        }

        $.ajax({
            url : data.url,
            type: 'POST',
            data: {
                action         : data.action,
                _ajax_nonce    : data.nonce,
                mobile         : mobile,
                form_id        : form_id,
                mobile_field_id: mobile_field_id
            },
            beforeSend: function (jqXHR, settings) {
                el.prop('disabled', true);
            },
            success: function (data, textStatus, jqXHR) {
                console.log(textStatus);
                console.log(data);
                show_timer(el, data.data.seconds);
            },
            error: function (jqXHR, textStatus, errorThrown) {
                el.prop('disabled', false);

                console.log(textStatus);
                console.log(errorThrown);
            }
        });


        // return;

        // let mobile = jQuery('#' + data['input_mobile_id']).val();
        // if (!mobile) {
        //     alert('لطفا موبایل را وارد کنید');
        //     return;
        // }
        //
        // ajax_send_otp(mobile);
    });

});