jQuery(document).ready(function($) {
    
    $('#btn-refresh-credit').on('click', function() {
        let el_btn_refresh = $(this);
        let el_span_credit = $('#span-credit');

        $.ajax({
            url: webone_sms_admin_js_obj.url,
            type: 'POST',
            data: {
                action     : webone_sms_admin_js_obj.action,
                _ajax_nonce: webone_sms_admin_js_obj.refresh_credit_nonce
            },
            beforeSend: function() {
                el_btn_refresh.prop('disabled', true);
                el_btn_refresh.html(`<span class="spinner is-active" style="margin: 0px;"></span>`);
            },
            success: function(result) {
                el_span_credit.text(
                    result.data.credit.toLocaleString()
                );
            },
            error: function(err) {
                console.log(err);
                // TODO: show error message
            },
            complete: function() {
                el_btn_refresh.prop('disabled', false);
                el_btn_refresh.html(`<span class="dashicons dashicons-image-rotate"></span>`);
            }
        });
    });

    $('#btn-get-patterns').on('click', function() {
        let el_btn_get_patterns = $(this);

        $.ajax({
            url: webone_sms_admin_js_obj.url,
            type: 'POST',
            data: {
                action     : webone_sms_admin_js_obj.get_patterns_action,
                _ajax_nonce: webone_sms_admin_js_obj.get_patterns_nonce
            },
            beforeSend: function() {
                el_btn_get_patterns.prop('disabled', true);
                el_btn_get_patterns.after(`
                    <span id="spinner-get-patterns" class="spinner is-active" style="margin: 0px; float: unset; padding-bottom: 3px;"></span>
                `);
            },
            success: function(result) {
                let message = 'موفقیت';
                message += '\n';
                message += 'تعداد ایجاد شده: ' + result.data.number_of_created;
                message += '\n';
                message += 'تعداد ویرایش شده: ' + result.data.number_of_updated;
                message += '\n';
                message += 'تعداد حذف شده: ' + result.data.number_of_deleted;

                alert(message);
            },
            error: function(err) {
                // TODO: show error message
                alert('خطایی رخ داده است');
            },
            complete: function() {
                el_btn_get_patterns.prop('disabled', false);
                $('#spinner-get-patterns').remove();

                window.location.reload();
            }
        });
    });


    $('.webone-sms-integration-select-plugin').on('change', function () {
        let that = $(this);
        let plugin = $(this).attr('data-plugin');
        let is_active = $(this).find(':selected').val();

        if (!confirm('آیا مطمئن هستید؟')) {
            return;
        }

        $.ajax({
            url: webone_sms_admin_js_obj.url,
            type: 'POST',
            data: {
                action     : webone_sms_admin_js_obj.plugin_toggle_action,
                _ajax_nonce: webone_sms_admin_js_obj.plugin_toggle_nonce,
                plugin     : plugin,
                is_active  : is_active
            },
            beforeSend: function() {
                that.prop('disabled', true);
            },
            success: function(result) {
                //
            },
            error: function(err) {
                // TODO: show error message
                alert('خطایی رخ داده است');
            },
            complete: function() {
                that.prop('disabled', false);
            }
        });
    });



    document.querySelectorAll('.accordion-header').forEach(header => {
        header.addEventListener('click', () => {
            const content = header.nextElementSibling;
            const isActive = content.classList.contains('active');
            document.querySelectorAll('.accordion-content').forEach(item => {
                item.classList.remove('active');
                item.style.maxHeight = null;
            });
            if (!isActive) {
                content.classList.add('active');
                content.style.maxHeight = content.scrollHeight + 'px';
            }
        });
    });

    document.querySelectorAll('.accordion-button').forEach(button => {
        button.addEventListener('click', () => {
            const content = button.nextElementSibling;
            const expanded = content.classList.contains('active');

            document.querySelectorAll('.accordion-content').forEach(c => {
                c.classList.remove('active');
                c.style.maxHeight = null;
            });

            if (!expanded) {
                content.classList.add('active');
                content.style.maxHeight = content.scrollHeight + 'px';
            }
        });
    });





});
